function [pTip, pPost, residuals ] = PivotCalibComputation( Flist )
% [pTip,pPost] = PivotCalibComputation(Flist)
% Computes pTip, pPost such that Flist(i)*pTip=pPost
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

[N1,N2] = size(Flist); N=0;
M = []; b=[];
for i=1:N1
    for j=1:N2
        N = N+1;
        M = [M;[Flist(i,j).R.el,-eye(3)]];
        b = [b; -Flist(i,j).p.el];
    end
end

if N<2
    throw(MException('Navigation:PivotCal','Not enough data to perform pivot calibration computation',N));
end

pp = M\b;
pTip = vct3(pp(1:3));
pPost = vct3(pp(4:6));

res = M*pp-b;
residuals = reshape(res,3,N1*N2);
end

